package jamezo97.clonecraft.network;

import jamezo97.clonecraft.block.TileEntityCentrifuge;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Handler0UpdateCentrifugeInfo extends Handler{

	@Value(id=0)
	NBTTagCompound nbt;
	
	public Handler0UpdateCentrifugeInfo(){}
	
	public Handler0UpdateCentrifugeInfo(NBTTagCompound nbt){
		this.nbt = nbt;
	}

	@SideOnly(value = Side.CLIENT)
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(nbt != null){
			TileEntityCentrifuge te1 = new TileEntityCentrifuge();
			te1.readFromNBT(nbt);
			World theWorld = Minecraft.getMinecraft().theWorld;
			if(theWorld != null){
				TileEntity te2 = theWorld.getBlockTileEntity(te1.xCoord, te1.yCoord, te1.zCoord);
				if(te2 instanceof TileEntityCentrifuge){
					TileEntityCentrifuge tec = (TileEntityCentrifuge)te2;
					tec.readFromNBT(nbt);
				}
			}
		}
	}

}
